#include <p30fxxxx.h>
#include <xlcd.h>

/*External LCD functions are only defined for the following devices */
#if defined(__dsPIC30F5011__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/*******************************************************************
Function Name:          OpenXLCD
Description:            This function configure the IO pins  
                        and initializes the LCD controller
                        the lcdtype should contain data on the type 
                        of interface and number of lines of display.
Input parameters:       char lcdtype 
Return value:           none
********************************************************************/
void OpenXLCD(char lcdtype)
{
    /*Initialize the data port/control pins to zero */
    DATA_PIN_7 = 0;
    DATA_PIN_6 = 0;
    DATA_PIN_5 = 0;
    DATA_PIN_4 = 0;

# ifdef EIGHT_BIT_INTERFACE
    DATA_PIN_3 = 0;
    DATA_PIN_2 = 0;
    DATA_PIN_1 = 0;
    DATA_PIN_0 = 0;
#endif

    RW_PIN = 0;
    RS_PIN = 0;
    E_PIN = 0;

    /* Configure the data pins as input */
    TRIS_DATA_PIN_7 = 1;
    TRIS_DATA_PIN_6 = 1;
    TRIS_DATA_PIN_5 = 1;
    TRIS_DATA_PIN_4 = 1;

# ifdef EIGHT_BIT_INTERFACE
    TRIS_DATA_PIN_3 = 1;
    TRIS_DATA_PIN_2 = 1;
    TRIS_DATA_PIN_1 = 1;
    TRIS_DATA_PIN_0 = 1;
#endif

    /* Make all control pins as outputs */
    TRIS_RW = 0;
    TRIS_RS = 0;
    TRIS_E = 0;

    /* Allow a delay for POR.(minimum of 15ms) */
    DelayPORXLCD();

    /* Set up the interface to the lcd.(give information about the 8-bit/4 bit interface) */
    WriteCmdXLCD(0x30); 

    /* Allow a delay of alteast 4.1 ms */
    DelayXLCD();

    /* Set up the interface to the lcd. ( give information about the 8-bit/4 bit interface) */
    WriteCmdXLCD(0x30);

    /* Allow a delay of alteast 100 micro secs */
    Delay100XLCD();

    /* Set up the interface to the lcd. ( give information about the 8-bit/4 bit interface) */
    WriteCmdXLCD(0x30);

    /* Wait till BF is 0 */
    while(BusyXLCD()); 

    WriteCmdXLCD(lcdtype);

    TRIS_DATA_PIN_7 = 0;
    DATA_PIN_7 = 0;

    /* Wait till BF is 0 */
    while(BusyXLCD());

    WriteCmdXLCD(DOFF & CURSOR_OFF & BLINK_OFF);

    /* Wait till BF is 0 */
    while(BusyXLCD());

    /* to clear display */
    WriteCmdXLCD( 0x01);    

    /* Wait till BF is 0 */
    while(BusyXLCD());   

    /* Wait till BF is 0 */
    while(BusyXLCD());

    /* to shift cursor left after display */
    WriteCmdXLCD(SHIFT_CUR_LEFT);

    /* Wait till BF is 0 */
    while(BusyXLCD());

    /* to set DDRAM address to start */
    SetDDRamAddr(0);
  
    /* Wait till BF is 0 */
    while(BusyXLCD()); 

    /* to increment the AC for every read/write */
    WriteCmdXLCD(0x06);  

    /* Wait till BF is 0 */
    while(BusyXLCD()); 
    WriteCmdXLCD(lcdtype);

} /* end of function */

#endif
/* end of file */
